//======================================================
//Thermodynamics - An Engineering approach
//Chapter-09, Gas power cycles
//Exercise: 9.7, Page No: 515
//Title : The Brayton cycle with regeneration
 //=======================================================
model Ex9_7
  //=======================================================
    //Variable section
            Real h5(unit = "kJ/Kg") "Enthalpy";
            Real q_in(unit = "kJ/Kg") "Heat input";
           Real eta_th "Thermal efficiency";
      Real eta_th_1(unit = "%") "Thermal efficiency";
     
    //=======================================================
    //Parameter section
    parameter Real epsilon = 0.8;
    parameter Real h2_a(unit = "kJ/Kg") = 605.39 "Enthalpy";
    parameter Real h4_a(unit = "kJ/Kg") = 880.36 "Enthalpy";
    parameter Real h3(unit = "kJ/Kg") = 1395.97 "Enthalpy";
    parameter Real W_net(unit = "kJ/Kg") = 210.41 "Net work";
    //=======================================================
    //Equation section
  equation
  h5 = (epsilon*h4_a + h2_a*(1-epsilon));
  q_in = h3-h5;
  eta_th = W_net/q_in;
  eta_th_1 = eta_th*100;
  //=======================================================
end Ex9_7;