//======================================================
//Thermodynamics - An Engineering approach
//Chapter-01, Introduction and basic concepts
//Exercise: 1.12, Page No: 
//Title: Problem solving technique
//=====================================================
class Ex1_12
 //Variable section
 Real P(unit = "Pa") "Pressure in Pa";
 Real P1(unit = "kPa") "Pressure in kPa";
 Real h3(unit = "m") "Height of mercury";
 //=====================================================
 //Parameter section
 parameter Real Patm(unit = "Pa") = 85600 "Atmospheric pressure in Pa";
 parameter Real rho_water(unit = "Kg/m3") = 1000 "Density of water";
 parameter Real rho_Hg(unit = "Kg/m3") = 13600 "Density of water";
 parameter Real rho_oil(unit = "Kg/m3") = 850 "Density of oil";
 parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
 parameter Real h_1(unit = "m") = 0.1 "Height of water in m";
 parameter Real h_2(unit = "m") = 0.2 "Height of oil in m";
 parameter Real h_3(unit = "m") = 0.35 "Height of mercury in m";
 parameter Real rho_Hg_new(unit = "Kg/m3") = 1030 "Density of new mercury which is replaced with sea water";
 //=====================================================
 //Equation section
 equation
  P = (Patm + (g*((h_3*rho_Hg)-((h_1*rho_water)+(h_2*rho_oil)))));
  P1 = P/1000;
   h3 = (P-Patm+(h_1*g*rho_water)+(h_2*rho_oil*g))/(g*rho_Hg_new);
 
 //=====================================================
end Ex1_12;