//======================================================
//Thermodynamics - An Engineering approach
//Chapter-01, Introduction and basic concepts
 //Exercise: 1.6, Page No: 26
 //Title: The Manometer
 //=====================================================
model Ex1_6
 //Variable section
 Real P(unit = "kPa") "Absolute pressure in kPa";
 //=====================================================
 //Parameter section
 parameter Real Patm(unit = "kPa") = 96 "Atmospheric pressure in kPa";
 parameter Real rho(unit = "Kg/m3") = 850 "Density of water";
 parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
 parameter Real h(unit = "m") = 0.55 "Height of manometer column";
 //=====================================================
 //Equation section
 equation
 P = (Patm + ((rho*g*h)/1000));//1000 is divided to convert pressure from Pa to kPa
 //=====================================================
end Ex1_6;