//======================================================
//Thermodynamics - An Engineering approach
//Chapter-01, Introduction and basic concepts
 //Exercise: 1.7, Page No: 28
 //Title: The Manometer
 //=====================================================
class Ex1_7
 //Variable section
 Real P(unit = "kPa") "Pressure in kPa";
 //=====================================================
 //Parameter section
 parameter Real Patm(unit = "kPa") = 85.6 "Atmospheric pressure in kPa";
 parameter Real rho_water(unit = "Kg/m3") = 1000 "Density of water";
 parameter Real rho_Hg(unit = "Kg/m3") = 13600 "Density of water";
 parameter Real rho_oil(unit = "Kg/m3") = 850 "Density of water";
 parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
 parameter Real h_1(unit = "m") = 0.1 "Height of tank at point 1in m";
 parameter Real h_2(unit = "m") = 0.2 "Height of tank at point 2 in m";
 parameter Real h_3(unit = "m") = 0.35 "Height of tank at point 3 in m";
 //=====================================================
 //Equation section
 equation
 P = (Patm + (g*((h_3*rho_Hg)-((h_1*rho_water)+(h_2*rho_oil)))/1000));//1000 is divided to convert pressure from Pa to kPa
 //=====================================================
end Ex1_7;