//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-11, Refrigeration Cycles
//Exercise: 11.1
//============================================================================
model Ex11_1
//Variable section
Real QL(unit = "kW")    "Heat removal from refrigerated space";
Real QH(unit = "kW")  "Heat rejection to environment";
Real h4(unit = "kJ/kg")     "enthalpy at throttling";
Real w(unit = "kW")         "Power input to the compressor";
Real COP(unit = "-")  "Coefficient of performance of refrigerator";

//=============================================================================
// Parameters
parameter Real m(unit = "kg/s") =0.05     "Mass of refrigerant";
parameter Real P1(unit = "MPa") =0.14       "Pressure at state 1";
parameter Real P2(unit = "MPa") =0.8     "Pressure at state 2";
parameter Real P3(unit = "MPa") =0.8      "Pressure at state 3";
parameter Real h1(unit = "kJ/kg") = 239.16     "enthalpy at P1";
parameter Real h2(unit = "kJ/kg") = 275.39    "enthalpy at P2";
parameter Real h3(unit = "kJ/kg") = 95.47    "enthalpy at P3";
//=============================================================================
// Equations
equation
h4=h3;
QL=m*(h1-h4);
w=m*(h2-h1);
QH=m*(h2-h3);
COP=QL/w;
//=============================================================================
end Ex11_1;
