//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-11, Refrigeration Cycles
//Exercise: 11.5
//============================================================================
model Ex11_5
//Variable section
Real Pr2(unit = "-")    "Pressure ratio at state 2";
Real Pr4(unit = "-")    "Pressure ratio at state 4";
Real Ql(unit = "BTU/lbm")    "Heat removal from refrigerated space";
Real Qr(unit = "BTU/s")    "rate of refrigeration";
Real wc(unit = "BTU/lbm")    "Power input to the compressor";
Real wt(unit = "BTU/lbm")  "Power input to turbine";
Real COP(unit = "-")  "Coefficient of performance";
//=============================================================================
// Parameters
parameter Real T1(unit = "R") = 460    "Temperature at state 1";
parameter Real T3(unit = "R") = 540    "Temperature at state 3";
parameter Real T2(unit = "R") = 683    "Temperature at state 2";
parameter Real T4(unit = "R") = 363    "Temperature at state 4";
parameter Real m(unit = "lbm/s") =0.1  "Mass of refrigeration";
parameter Real h1(unit = "BTU/lbm") = 109.90   "enthalpy at state 1";
parameter Real h2(unit = "BTU/lbm") = 163.5   "enthalpy at state 2";
parameter Real h3(unit = "BTU/lbm") = 129.06   "enthalpy at state 3";
parameter Real h4(unit = "BTU/lbm") = 86.7   "enthalpy at state 4";
parameter Real Pr1(unit = "-") =  0.7913   "Pressure ratio at state 1";
parameter Real Pr3(unit = "-") =  1.386   "Pressure ratio at state 3";
parameter Real P2_1(unit = "-") =  4  "Pressure ratioof 2 to 1";
parameter Real P4_3(unit = "-") =  0.25   "Pressure ratio of 4 to 3";
//=============================================================================
// Equations
equation
Pr2=P2_1*Pr1;
Pr4=P4_3*Pr3;
Ql=h1-h4;
wt=h3-h4;
wc=h2-h1;
COP=(Ql/(wc-wt));
Qr=Ql*m;
//=============================================================================
end Ex11_5;