//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-12, Thermodynamic Property Relations
//Exercise: 12.11
//============================================================================
model Ex12_11
//Variable section
Real Dhi(unit = "kJ/kmol")    "Change in enthalpy calculated based on ideal gas law";
Real Dsi(unit = "kJ/kmol-K")  "Change in entropy calculated based on ideal gas law";
Real Dhr(unit = "kJ/kmol") "Change in enthalpy calculated based on Real gas formula";
Real Dsr(unit = "kJ/kmol-K")  "Change in entropy calculated based on Real gas formula";
Real Tr1(unit = "K")       "Reduced Temperature at state 1";
Real Tr2(unit = "K")       "Reduced Temperature at state 2";
Real Pr1(unit = "MPa")       "Reduced Pressure at state 1";
Real Pr2(unit = "MPa")       "Reduced Pressure at state 2";
Real Eh(unit = "%")          "error in enthalpy value calculated from  from ideal gas law"; 
Real Es(unit = "%")          "error in entropy value calculated from  from ideal gas law"; 
//=============================================================================
// Parameters
parameter Real h1(unit = "kJ/kg") =6404    "Enthalpy at state 1";
parameter Real h2(unit = "kJ/kg") =8736   "Enthalpy at state 2";
parameter Real s1(unit = "kJ/kg-K") = 196.171     "Entropy at state 1";
parameter Real s2(unit = "kJ/kg-K") = 205.213   "Entropy at state 2";
parameter Real T1(unit = "K") =220       "Temperature at state 1";
parameter Real T2(unit = "K")  =300     "Temperature at state 2";
parameter Real Tc(unit = "K") =154.8      "Critical Temperature of oxygen";
parameter Real P1(unit = "MPa") =5       "Pressure at state 1";
parameter Real P2(unit = "MPa") =10      "Pressure at state 2";
parameter Real Pc(unit = "MPa") = 5.08      "Critical Pressure of oxygen";
parameter Real R(unit = "kPa m3/kg K") =8.314 "Universal gas constant";
parameter Real Zh1(unit = "-") = 0.53      "compressibility factor for enthalpy at state 1";
parameter Real Zh2(unit = "-") = 0.48      "compressibility factor for enthalpy at state 2";
parameter Real Zs1(unit = "-") = 0.25      "compressibility factor for entropy at state 1";
parameter Real Zs2(unit = "-") = 0.20      "compressibility factor for entropy at state 2";
//=============================================================================
// Equations
extends Modelica.Math;
equation
Dhi=(h2-h1);
Dsi=(s2-s1)-(R*log(P2/P1));
Tr1=T1/Tc;
Pr1=P1/Pc;
Tr2=T2/Tc;
Pr2=P2/Pc;
Dhr=Dhi-(R*Tc*(Zh2-Zh1));
Dsr=Dsi-(R*(Zs2-Zs1));
Eh=((Dhr-Dhi)/(Dhr))*100;
Es=((Dsr-Dsi)/(Dsr))*100; 
//"The values are slightly different due to rounding off errors"
//=============================================================================
end Ex12_11;