//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-13, Gas Mixtures
//Exercise: 13.1
//============================================================================
model Ex13_1
//Variable section
Real mt(unit = "kg")    "Total Mass of gas mixture";
Real Nt(unit = "kmol")    "Total Moles of gas mixture";
Real mfO2(unit = "-")    "Mass fraction of O2 in gas mixture";
Real mfN2(unit = "-")    "Mass fraction of N2 in gas mixture";
Real mfCH4(unit = "-")    "Mass fraction of CH4 in gas mixture";
Real NO2(unit = "kmol")    "Moles of O2 in gas mixture";
Real NN2(unit = "kmol")    "Moles of N2 in gas mixture";
Real NCH4(unit = "kmol")    "Moles of CH4 in gas mixture";
Real XO2(unit = "-")       "Mole fraction of O2 in gas mixture";
Real XN2(unit = "-")       "Mole fraction of N2 in gas mixture";
Real XCH4(unit = "-")      "Mole fraction of CH4 in gas mixture";
Real mwa(unit = "kg/kmol")    "Average molar mass of gas mixture";
Real Rm(unit = "kj/kg-K")     "Average gas constant";
//=============================================================================
// Parameters
parameter Real mO2(unit = "kg") = 3       "Mass of O2 in gas mixture";
parameter Real mN2(unit = "kg") = 5    "Mass of N2 in gas mixture";
parameter Real mCH4(unit = "kg") = 12     "Mass of CH4 in gas mixture";
parameter Real mwO2(unit = "kg/kmol") = 32       "Mass of O2 in gas mixture";
parameter Real mwN2(unit = "kg/kmol") = 28    "Mass of N2 in gas mixture";
parameter Real mwCH4(unit = "kg/kmol") = 16     "Mass of CH4 in gas mixture";
parameter Real R(unit = "kj/kmol-K") =8.314    "Universal gas constant";
//=============================================================================
// Equations
equation
mt=(mO2+mN2+mCH4);  
mfO2= mO2/mt;
mfN2= mN2/mt;
mfCH4= mCH4/mt;
NO2= mO2/mwO2;
NN2= mN2/mwN2;
NCH4= mCH4/mwCH4;
Nt=NO2+NN2+NCH4;
XO2=NO2/Nt;
XN2=NN2/Nt;
XCH4=NCH4/Nt;
mwa=mt/Nt;
Rm=R/mwa;
//=============================================================================
end Ex13_1;