package Ex13_6
//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-13, Gas Mixtures
//Exercise: 13.6a
//============================================================================
model Ex13_6_a
//Variable section
Real Mm(unit = "-")     "Molecular weight of sea water mixture";
Real xs(unit = "-")    "Mole fraction of salt";
Real xw(unit = "-")    "Mole fraction of water";
//=============================================================================
// Parameters
parameter Real ms(unit = "-") =0.0348   "Mass fraction of salt";
parameter Real mw(unit = "-") = 0.9652   "Mass fraction of water";
parameter Real Ms(unit = "-") =58.44   "Molecular weight of salt";
parameter Real Mw(unit = "-") =18    "Molecular weight of water";
//=============================================================================
// Equations
extends Modelica.Math;
equation
Mm=1/((ms/Ms)+(mw/Mw));
xw=Mm*(mw/Mw);
xs=1-xw;
//"The answer may slightly vary due to roundoff error"
//=============================================================================
  end Ex13_6_a;

  //============================================================================
  //Thermodynamics - An Engineering approach
  //Chapter-13, Gas Mixtures
  //Exercise: 13.6b
  //============================================================================
  model Ex13_6_b
  //Variable section
  Real Mm(unit = "-")     "Molecular weight of sea water mixture";
  Real xs(unit = "-")    "Mole fraction of salt";
  Real xw(unit = "-")    "Mole fraction of water";
  Real Win_mo(unit = "kJ/kmol")    "work input required to separate 1 kmol of sea water";
  Real Win_ma(unit = "kJ/kg")    "work input required to separate 1 kg of sea water";
  //=============================================================================
  // Parameters
  parameter Real T(unit = "C") = 288.15   "Temperature of sea water";
  parameter Real ms(unit = "-") =0.0348   "Mass fraction of salt";
  parameter Real mw(unit = "-") = 0.9652   "Mass fraction of water";
  parameter Real Ms(unit = "-") =58.44   "Molecular weight of salt";
  parameter Real Mw(unit = "-") =18    "Molecular weight of water";
  parameter Real R(unit = "kJ/kmol-K") =8.314    "Universal gas constant";
  
  //=============================================================================
  // Equations
  extends Modelica.Math;
  equation
  Mm=1/((ms/Ms)+(mw/Mw));
  xw=Mm*(mw/Mw);
  xs=1-xw;
  Win_mo=-R*T*((xw*log(xw))+(xs*log(xs)));
  Win_ma=Win_mo/Mm;
  //"The answer may slightly vary due to roundoff error"
  //=============================================================================
  end Ex13_6_b;

  model Ex13_6_c
  //Variable section
  Real Mm(unit = "-")     "Molecular weight of sea water mixture";
  Real xs(unit = "-")    "Mole fraction of salt";
  Real xw(unit = "-")    "Mole fraction of water";
  Real Win_mo(unit = "kJ/kmol")    "work input required to produce pure water from 1 kmol of sea water";
  Real Win_ma(unit = "kJ/kg")   "work input required to produce pure water from 1 kg of sea water";
  Real Win_ma2(unit = "kJ/kg")  "work input required to produce 1 kg of pure water from sea water";
  //=============================================================================
  // Parameters
  parameter Real T(unit = "C") = 288.15   "Temperature of sea water";
  parameter Real ms(unit = "-") =0.0348   "Mass fraction of salt";
  parameter Real mw(unit = "-") = 0.9652   "Mass fraction of water";
  parameter Real Ms(unit = "-") =58.44   "Molecular weight of salt";
  parameter Real Mw(unit = "-") =18    "Molecular weight of water";
  parameter Real R(unit = "kJ/kmol-K") =8.314    "Universal gas constant";
  parameter Real Rg(unit = "kJ/kg-K") =0.4615    "gas constant for pure water";
  //=============================================================================
  // Equations
  extends Modelica.Math;
  equation
  Mm=1/((ms/Ms)+(mw/Mw));
  xw=Mm*(mw/Mw);
  xs=1-xw;
  Win_mo=-R*T*((xw*log(xw))+(xs*log(xs)));
  Win_ma=Win_mo/Mm;
  Win_ma2=Rg*T*log(1/xw);
  //"The answer may slightly vary due to roundoff error"
  //=============================================================================
  end Ex13_6_c;

  model Ex13_6_d
  //Variable section
  Real Mm(unit = "-")     "Molecular weight of sea water mixture";
  Real xs(unit = "-")    "Mole fraction of salt";
  Real xw(unit = "-")    "Mole fraction of water";
  Real Win_mo(unit = "kJ/kmol")    "work input required to produce pure water from 1 kmol of sea water";
  Real Win_ma(unit = "kJ/kg")   "work input required to produce pure water from 1 kg of sea water";
  Real Win_ma2(unit = "kJ/kg")  "work input required to produce 1 kg of pure water from sea water";
  Real DelP(unit = "kPa")    "Osmotic Pressure required to get fresh water from sea water";
  Real DelZ(unit = "m")    "Minimum height required to get fresh water from sea water";
  //=============================================================================
  // Parameters
  parameter Real T(unit = "C") = 288.15   "Temperature of sea water";
  parameter Real rho(unit = "kg/m3") = 1028   "Density of sea water";
  parameter Real ms(unit = "-") =0.0348   "Mass fraction of salt";
  parameter Real mw(unit = "-") = 0.9652   "Mass fraction of water";
  parameter Real Ms(unit = "-") =58.44   "Molecular weight of salt";
  parameter Real Mw(unit = "-") =18    "Molecular weight of water";
  parameter Real R(unit = "kJ/kmol-K") =8.314    "Universal gas constant";
  parameter Real Rg(unit = "kJ/kg-K") =0.4615    "gas constant for pure water";
  parameter Real g(unit = "m/s2") =9.81    "Gravity due to acceleration";
  //=============================================================================
  // Equations
  extends Modelica.Math;
  equation
  Mm=1/((ms/Ms)+(mw/Mw));
  xw=Mm*(mw/Mw);
  xs=1-xw;
  Win_mo=-R*T*((xw*log(xw))+(xs*log(xs)));
  Win_ma=Win_mo/Mm;
  Win_ma2=Rg*T*log(1/xw);
  DelP=rho*Rg*T*log(1/xw);
  DelZ=Win_ma2*1000/g;
  //"The answer may slightly vary due to roundoff error"
  //=============================================================================
  end Ex13_6_d;
end Ex13_6;
