//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-15, Chemical Reactions
//Exercise: 15.1
//============================================================================
model Ex15_1
//Variable section

Real m_air(unit = "kg")    "Mass of air";
Real N_air(unit = "kmol")  "Moles of air";
Real m_C(unit = "kg")    "Mass of C in product";
Real m_H2(unit = "kg")    "Mass of H2 in product";
Real af_r(unit = "kg air/kg fuel")    "air to fuel mass ratio";
//=============================================================================
// Parameters
parameter Real M_C(unit = "kg/kmol")=12    "Molecular weight of C";
parameter Real M_O2(unit = "kg/kmol")  =32  "Molecular weight of O2";
parameter Real M_N2(unit = "kg/kmol") =28   "Molecular weight of N2";
parameter Real M_H2(unit = "kg/kmol") =2  "Molecular weight of H2";
parameter Real M_air(unit = "kg/kmol") = 29   "Molecular weight of air";
parameter Real N_C(unit = "kmol") =8    "Moles of C in product";
parameter Real N_N2(unit = "kmol") = 75.2    "Moles of N2 in product";
parameter Real N_H2(unit = "kmol") = 9    "Moles of H2 in product";
parameter Real N1_O2(unit = "kmol") = 20    "Moles of O2 in air";
//=============================================================================
// Equations
equation
N_air=N1_O2*4.76;
m_air=N_air*M_air;
m_C=N_C*M_C;
m_H2=N_H2*M_H2;
af_r=m_air/(m_C+m_H2);
//=============================================================================
end Ex15_1;