//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-15, Chemical Reactions
//Exercise: 15.4
//============================================================================
model Ex15_4
//Variable section
Real m_air(unit = "kg")    "Mass of air";
Real m_f(unit = "kg")      "Mass of fuel";
Real Na_air(unit = "kmol")  "Moles of actual amount of air";
Real Nt_air(unit = "kmol")  "Moles of theoretical amount of air";
Real m_C(unit = "kg")    "Mass of C in product";
Real m_H2(unit = "kg")    "Mass of H2 in product";
Real af_r(unit = "-")    "air to fuel mass ratio";
Real Ea_r(unit = "%")    "Actual air to theoretical air ratio";
Real Nv(unit = "kmol")  "Moles of Water vapor condenses in product";
//=============================================================================
// Parameters
parameter Real M_C(unit = "kg/kmol")= 12    "Molecular weight of C";
parameter Real M_H2(unit = "kg/kmol") =2  "Molecular weight of H2";
parameter Real M_air(unit = "kg/kmol") = 29   "Molecular weight of air";
parameter Real N_C(unit = "kmol") =8 "Moles of C in product";
parameter Real N_H2(unit = "kmol") = 9  "Moles of H2 in product";
parameter Real N1_O2(unit = "kmol") = 16.32    "Moles of actual O2 in air";
parameter Real N2_O2(unit = "kmol") = 12.5    "Moles of theoretical O2 in air";
parameter Real Pv(unit = "kPa") = 3.1698    "Partial pressure of water vapor";
parameter Real Pp(unit = "kPa") = 100   "Product pressure";
//=============================================================================
// Equations
equation
Na_air=N1_O2*4.76;
m_air=Na_air*M_air;
m_C=N_C*M_C;
m_H2=N_H2*M_H2;
m_f=(m_C+m_H2);
af_r=m_air/m_f;
Nt_air=N2_O2*4.76;
Ea_r=Na_air*100/Nt_air;
Nv=(900-82.53*Pv)/(Pp-Pv);
//The answer may vary due to roundoff error
//=============================================================================
end Ex15_4;