//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-15, Chemical Reactions
//Exercise: 15.5
//============================================================================
model Ex15_5
//Variable section
Real Hc1_C8H18(unit = "kJ/kmol")    "Enthalpy of combustion of C8H18 per kmol ";
Real Hc2_C8H18(unit = "kJ/kg")    "Enthalpy of combustion of C8H18 per kg";
//=============================================================================
// Parameters
parameter Real M_C8H18(unit = "kg/kmol") = 114    "Molecular weight of C8H18 ";
parameter Real N_CO2(unit = "kmol") =8   "Moles of CO2 ";
parameter Real N_H2O(unit = "kmol") = 9   "Moles of H2O ";
parameter Real N_C8H18(unit = "kmol") = 1    "Moles of C8H18 ";
parameter Real Hf_CO2(unit = "kJ/kmol") = -393520  "Enthalpy of formation of CO2 ";
parameter Real Hf_H2O(unit = "kJ/kmol") = -285830  "Enthalpy of formation of H2O ";
parameter Real Hf_C8H18(unit = "kJ/kmol") = -249950   "Enthalpy of formation of C8H18 ";
//=============================================================================
// Equations
equation
Hc1_C8H18= (N_CO2*Hf_CO2)+(N_H2O*Hf_H2O)-(N_C8H18*Hf_C8H18);
Hc2_C8H18 = Hc1_C8H18/M_C8H18;
//The answer may vary due to roundoff error
//=============================================================================
end Ex15_5;