//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-16, Chemical and Phase Equilibrium
//Exercise: 16.1
//============================================================================
model Ex16_1
//Variable section
Real Del_G(unit = "kJ/kmol")    "Change in gibbs energy";
Real Kp(unit = "-")    "Equilibrium constant";
//=============================================================================
// Parameters
parameter Real Sc_N(unit = "-")= 2    "Stoichiometric coefficeient of N";
parameter Real Sc_N2(unit = "-") =1   "Stoichiometric coefficeient of N2";
parameter Real GN(unit = "kJ/kmol") = 455510    "Gibbs formation for N2";
parameter Real GN2(unit = "kJ/kmol") = 0    "Gibbs formation for N";
parameter Real T(unit = "K") = 298    "Temperature at the dissociation process";
parameter Real R(unit = "kJ/kmol-K") =8.314    "Universal gas constant";
//=============================================================================
extends Modelica.Math;
// Equations
equation
Del_G=(Sc_N*GN)+(Sc_N2*GN2);
Kp=exp(-Del_G/(R*T));
//=============================================================================
end Ex16_1;