//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-16, Chemical and Phase Equilibrium
//Exercise: 16.10
//============================================================================
model Ex16_10
//Variable section
Real rho_mo(unit = "kmol/m3")  "Molar density of H2 in the Nickel plate";
Real rho_ma(unit = "kg/m3")  "Mass density of H2 in the Nickel plate";
//=============================================================================
// Parameters
parameter Real T(unit = "K")  = 358  "Temperature of H2 in the tank";
parameter Real Mw(unit = "kg/kmol")  = 2  "Molecular weight of H2 in the tank";
parameter Real P(unit = "bar")  = 3  "Atmospheric pressure at lake level";
parameter Real S(unit = "kmol/m3-bar") = 0.00901   "Henry constant of air dissolved in lake at T";
//=============================================================================
// Equations
equation
rho_mo=S*P;
rho_ma=rho_mo*Mw;
//=============================================================================
end Ex16_10;