//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-16, Chemical and Phase Equilibrium
//Exercise: 16.7
//============================================================================
model Ex16_7
//Variable section
Real Gf(unit = "kJ/kg")    "Gibbs energy for saturated water condition";
Real Gg(unit = "kJ/kg")    "Gibbs energy for saturated water vapor condition";
//=============================================================================
// Parameters
parameter Real T(unit = "K")  = 393.15  "Temperature";
parameter Real hf(unit = "kJ/kg")  = 503.81  "Fluid enthalpy at temperature T";
parameter Real hg(unit = "kJ/kg")  = 2706  "Vapor enthalpy at temperature T";
parameter Real sf(unit = "kJ/kg-K")  =1.5279   "Fluid entropy at temperature T";
parameter Real sg(unit = "kJ/kg-K")  = 7.1292  "Vapor entropy at temperature T";
//=============================================================================
// Equations
equation
Gf= (hf-(T*sf));
Gg= (hg-(T*sg));
//"The answer may slightly vary due to roundoff error"
//=============================================================================
end Ex16_7;