//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-16, Chemical and Phase Equilibrium
//Exercise: 16.8
//============================================================================
model Ex16_8
//Variable section
Real yw(unit = "-")    "Mole fraction of water vapor in air";
//=============================================================================
// Parameters
parameter Real T(unit = "C")  = 15  "Temperature";
parameter Real Pv(unit = "kPa")  = 1.7057  "Saturation pressure of water at Temperature T";
parameter Real P(unit = "kPa")  = 92  "Atmospheric pressure at lake level";
parameter Real xa(unit = "-")  =0    "Mole fraction of air in lake";// Assuming the air in lake is negligible
parameter Real xw(unit = "-")  =1    "Mole fraction of water in lake";
//=============================================================================
// Equations
equation
yw= (Pv/P);
//=============================================================================
end Ex16_8;