//======================================================
//Thermodynamics - An Engineering approach
//Chapter-02, Energy, Energy transfer, and general energy analysis
//Exercise: 2.1, Page No: 57 
//Title: Nuclear energy 
//=====================================================
class Ex2_1
 //Variable section
 Real m_gasoline(unit = "Kg/day") "Mass of gasoline in Kg/hr";
 Real E(unit = "KJ/day") "Energy supplied to the car in KJ/Kg";
 Real e(unit = "KJ") "Complete fission of U-235 in KJ";
 Real n(unit = "days")"Number of days";
 //=====================================================
 //Parameter section
 parameter Real rho_gasoline(unit = "Kg/l") = 0.75 "Density of gasoline";
 parameter Real V(unit = "l/day") = 5 "Volumetric flowrate";
 parameter Real H(unit = "KJ/Kg") = 44000 "Heating value";
 parameter Real m(unit = "Kg") = 0.1 "New car consumption of U-235 fuel";
 parameter Real H_1(unit = "KJ/Kg") = 6.73*(10^10) "Heat energy of U-235";
  //=====================================================
 //Equation section
 equation
 m_gasoline = (rho_gasoline*V);
 E = (H*m_gasoline);
e = (H_1*m);
n = (e/E);
 //=====================================================
end Ex2_1;