//======================================================
//Thermodynamics - An Engineering approach
//Chapter-02, Energy, Energy transfer, and general energy analysis
//Exercise: 2.13, Page No: 77
//Title: Energy balance
//=====================================================
class Ex2_13
//Variable section
Real P(unit = "kW") "Lighting power in kW";
Real t(unit = "hr/year") "Operating hours in a year";
Real E(unit = "kWh/year") "Lighting energy/year";
Real Cost(unit = "$/year") "Cost of lighting a classroom for a year in dollar";
//=====================================================
//Parameter section
parameter Real p(unit = "W") = 80 "Power consumed by fluoroscent lamp in W";
parameter Real n = 30 "Number of lamps used";
parameter Real D(unit = "days") = 250 "Operating days in year";
parameter Real m(unit = "months") = 12 "Number of months per year";
parameter Real con = 0.07 "Conversion of rupees to dollar";
//=====================================================
//Equation section
equation
P = (p*n)/1000;
t = (D*m);
E = (P*t);
Cost = (E*con);
//======================================================
end Ex2_13;