//======================================================
//Thermodynamics - An Engineering approach
//Chapter-02, Energy, Energy transfer, and general energy analysis
//Exercise: 2.15, Page No: 82
//Title: Energy balance
//=====================================================
class Ex2_15
//Variable section
Real Q_utilized(unit = "kW") "Electrical power consumed in kW";
Real Q_input_gas(unit = "kW") "Energy input to the gas burner in kW";
Real Cost_1(unit = "$/kWh") "Cost of utlized energy by electrcity in $/kWh";
Real Cost_2(unit = "$/kWh") "Cost of utlized energy by natural gas in $/kWh";
//=====================================================
//Parameter section
parameter Real E(unit = "kW") = 2 "Energy input in kW";
parameter Real eta_electricity = 0.73 "Efficiency of electric units";
parameter Real eta_gas = 0.38 "Efficiency of natural gas";
parameter Real Cost_electricity(unit = "$/kWh") = 0.09 "Cost of electricity";
parameter Real Cost_gas(unit = "$/therm") = 0.55 "Cost of natural gas";
//=====================================================
//Equation section
equation
Q_utilized =  E*eta_electricity;
Cost_1 = Cost_electricity/eta_electricity;
Q_input_gas = Q_utilized/eta_gas;
Cost_2 = (Cost_gas/29.3)/eta_gas;
//======================================================
end Ex2_15;