//======================================================
//Thermodynamics - An Engineering approach
//Chapter-02, Energy, Energy transfer, and general energy analysis
//Exercise: 2.8, Page No: 69 
//Title: Power transmission 
//=====================================================
model Ex2_8
 //Variable section
 Real W_g(unit = "kJ/s") "Power transmitted in kW";
 Real W_g_1(unit = "hp") "Power in hp";
 //=====================================================
 //Parameter section
 parameter Real m(unit = "Kg") = 1200 "Mass of car";
 parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
 parameter Real del_z(unit = "Km/hr") = 90 ;
 parameter Real teta = 30 "Angle of hill in degrees";
 //=====================================================
 //Library section
extends Modelica.Constants;
extends Modelica.Math;
  //=====================================================
 //Equation section
 equation
 W_g = (m*g*del_z*(sin(teta*(pi/180))))/(1000*3.6);
// 1000 is divided to convert W to kW and 3.6 is divided to convert from Km/hr to m/s
 W_g_1 = W_g*1.34102;
//=====================================================
end Ex2_8;