//======================================================
//Thermodynamics - An Engineering approach
//Chapter-02, Energy, Energy transfer, and general energy analysis
//Exercise: 2.9, Page No: 69 
//Title: Power transmission 
//=====================================================
class Ex2_9
//Variable section
Real Wa(unit = "kJ") "Work needed to accelerate body in kJ";
Real W_avg(unit = "kW") "Average power in kW";
Real W_avg_1(unit = "hp") "Average power in hp";
//=====================================================
//Parameter section
parameter Real m(unit = "Kg") = 900 "Mass of car";
parameter Real del_t(unit = "sec") = 20 "Time in which the car has to reach its desired speed in seconds";
parameter Real V_2(unit = "Km/hr") = 80 "Final velocity of car";
parameter Real V_1(unit = "Km/hr") = 0 "Intial velocity of car is zero as car is at rest";
//=====================================================
//Equation section
equation
Wa = ((1/2)*(m*(((V_2*1000)/3600)^2)-((V_1*1000/3600)^2)))/1000;
// 1000 is divided to convert W to kW
W_avg = Wa/del_t;
W_avg_1 = W_avg*1.34102;
//=====================================================
end Ex2_9;