///============================================================================
//Thermodynamics - An Engineering approach
//Chapter-3, Properties of pure substances
//Exercise: 3.10
//============================================================================
model Ex3_10
//Variable section
Real V(unit = "m3")   "Volume of the room";
Real m(unit = "kg")   "Mass of air in the room " ;
//=============================================================================
// Parameters

parameter Real L(unit = "m") = 4    "Length of the room";
parameter Real B(unit = "m") = 5     "Breadth of the room";
parameter Real H(unit = "m") = 6    "Height of the room";
parameter Real T(unit = "K") = 298   "Temperatue of the room";
parameter Real P(unit = "kPa") = 100  "Pressure of the room";
parameter Real R(unit = "kPa-m3/kg-K") = 0.287  "Universal gas constant";
//=============================================================================
// Equations
equation
V=L*H*B;
m=(P*V)/(R*T);

//=============================================================================
end Ex3_10;