///============================================================================
//Thermodynamics - An Engineering approach
//Chapter-3, Properties of pure substances
//Exercise: 3.11
//Answer not rounded off
//============================================================================
model Ex3_11
//Variable section
Real Pr(unit = "-") "Reduced Pressure of the refrigerant";
Real Tr(unit = "-")   "Reduced Temperatue of the refrigerant";
Real sv_i(unit = "m3/kg")  "Specific volume using ideal gas conditions";
Real sv_c(unit = "m3/kg")  "Specific volume using compressibility factor";
Real Ei(unit = "%")  "Percentage Error for actual specific volume and calculated specific volume(at ideal conditions)";
Real Ec(unit = "%")  "Percentage Error for actual specific volume and calculated specific volume(using compressibility factor)";
//=============================================================================
// Parameters
parameter Real sv_a(unit = "m3/kg") = 0.021796    "Specific volume at actual conditions";
parameter Real P(unit = "Mpa") = 1     "Pressure of the refrigerant";
parameter Real Pc(unit = "Mpa") = 4.059     "Critical Pressure of the refrigerant";
parameter Real T(unit = "K") = 323  "Temperatue of the refrigerant";
parameter Real Tc(unit = "K") = 374.2  "Critical Temperatue of the refrigerant";
parameter Real R(unit = "kPa-m3/kg-K") = 0.0815 "gas constant";
parameter Real z(unit = "-") = 0.84  "Compressibility factor taken for the corresponding reduced pressure and temperature chart from the above mentioned chapter pg no:141";
//=============================================================================
// Equations
equation
sv_i=(R*T)/(P*1000);
Ei=((sv_i-sv_a)/sv_a)*100;
Pr=P/Pc;
Tr=T/Tc;
sv_c =z*sv_i;
Ec=((sv_c-sv_a)/sv_a)*100; //The error value is less than 2 percent and the answer is not rounded off
//=============================================================================
end Ex3_11;