//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-3, Properties of pure substances
//Exercise: 3.4
//============================================================================
model Ex3_4
//Variable section
Real v(unit = "m3")    "Total volume occupied in the tank";
//=============================================================================
// Parameters
parameter Real P(unit = "kPa") = 70.183     "Saturated pressure at 90 deg C";
parameter Real m1(unit = "kg") = 8    "Mass of the liquid in tank";
parameter Real m2(unit = "kg") = 2     "Mass of the vapor in tank";
parameter Real vf(unit = "m3/kg") = 0.001036     "Liquid Specific volume at 90 deg C";
parameter Real vg(unit = "m3/kg") = 2.3593   "Vapor Specific volume at 90 deg C";
//=============================================================================
// Equations
equation
v=(m1*vf)+ (m2*vg);
//=============================================================================
end Ex3_4;