package Ex3_5
  //============================================================================
  //Thermodynamics - An Engineering approach
  //Chapter-3, Properties of pure substances
  //Exercise: 3.5
  //Answers are not rounded off
  //============================================================================
  model EX3_5_a
  //Variable section
  Real v1(unit = "m3/kg")  "Specific volume";
  //=============================================================================
  // Parameters
  parameter Real V(unit = "m3") = 0.08   "Total volume occupied in the tank";
  parameter Real m(unit = "kg") = 4     "Mass of the refrigerant";
  parameter Real hf(unit = "kJ/kg") = 31.21   "Enthalpy 1 at 160 kPa";
  parameter Real hfg(unit = "kJ/kg") = 209.90  "Enthalpy 2 at 160 kPa";
  parameter Real vf(unit = "m3/kg") = 0.0007437   "Liquid Specific volume at 160 kPa";
  parameter Real vg(unit = "m3/kg") =  0.12348    "Gas Specific volume at 160 kPa";
  //=============================================================================
  // Equations
  equation
  v1=V/m;
  //=============================================================================
  end EX3_5_a;
  
  model Ex3_5_b
  //Variable section
  Real v1(unit = "m3/kg")  "Specific volume";
  Real x(unit = "-")  "Quality of refrigerant";
  //=============================================================================
  // Parameters
  parameter Real V(unit = "m3") = 0.08   "Total volume occupied in the tank";
  parameter Real m(unit = "kg") = 4     "Mass of the refrigerant";
  parameter Real hf(unit = "kJ/kg") = 31.21   "Enthalpy 1 at 160 kPa";
  parameter Real hfg(unit = "kJ/kg") = 209.90  "Enthalpy 2 at 160 kPa";
  parameter Real vf(unit = "m3/kg") = 0.0007437   "Liquid Specific volume at 160 kPa";
  parameter Real vg(unit = "m3/kg") =  0.12348    "Gas Specific volume at 160 kPa";
  //=============================================================================
  // Equations
  equation
  v1=V/m;
  x=(v1-vf)/(vg-vf);
  //=============================================================================
  end Ex3_5_b;

model Ex3_5_c
//Variable section
Real v1(unit = "m3/kg")  "Specific volume";
Real x(unit = "-")  "Quality of refrigerant";
Real h(unit = "kJ/kg")  "Enthalpy at 160 kPa";
//=============================================================================
// Parameters
parameter Real V(unit = "m3") = 0.08   "Total volume occupied in the tank";
parameter Real m(unit = "kg") = 4     "Mass of the refrigerant";
parameter Real hf(unit = "kJ/kg") = 31.21   "Enthalpy 1 at 160 kPa";
parameter Real hfg(unit = "kJ/kg") = 209.90  "Enthalpy 2 at 160 kPa";
parameter Real vf(unit = "m3/kg") = 0.0007437   "Liquid Specific volume at 160 kPa";
parameter Real vg(unit = "m3/kg") =  0.12348    "Gas Specific volume at 160 kPa";
//=============================================================================
// Equations
equation
v1=V/m;
x=(v1-vf)/(vg-vf);
h=hf+(x*hfg);
//=============================================================================
end Ex3_5_c;

model Ex3_5_d
//Variable section
Real v1(unit = "m3/kg")  "Specific volume";
Real x(unit = "-")  "Quality of refrigerant";
Real h(unit = "kJ/kg")  "Enthalpy at 160 kPa";
Real mg(unit = "kg")  "mass of vapor phase";
Real V1g(unit = "m3")  "volume occupied by vapor phase";
//=============================================================================
// Parameters
parameter Real V(unit = "m3") = 0.08   "Total volume occupied in the tank";
parameter Real m(unit = "kg") = 4     "Mass of the refrigerant";
parameter Real hf(unit = "kJ/kg") = 31.21   "Enthalpy 1 at 160 kPa";
parameter Real hfg(unit = "kJ/kg") = 209.90  "Enthalpy 2 at 160 kPa";
parameter Real vf(unit = "m3/kg") = 0.0007437   "Liquid Specific volume at 160 kPa";
parameter Real vg(unit = "m3/kg") =  0.12348    "Gas Specific volume at 160 kPa";
//=============================================================================
// Equations
equation
v1=V/m;
x=(v1-vf)/(vg-vf);
h=hf+(x*hfg);
mg=x*m;
V1g=mg*vg;
//=============================================================================
  end Ex3_5_d;
end Ex3_5;
