//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-3, Properties of pure substances
//Exercise: 3.8
//============================================================================
model Ex3_8
//Variable section
Real E(unit = "%")  "Error in %";
//=============================================================================
// Parameters
parameter Real p(unit = "MPa") = 5   "Total volume occupied in the tank";
parameter Real t(unit = "C") = 80     "Mass of the refrigerant";
parameter Real u1(unit = "kJ/kg") = 333.82   "Internal energy from compressed liquid table at 80 deg c";
parameter Real u2(unit = "kJ/kg") = 334.97 "Internal energy from Saturated liquid table";
//=============================================================================
// Equations
equation
E=((u2-u1)/u1)*100;
//=============================================================================
end Ex3_8;