//======================================================
//Thermodynamics - An Engineering approach
//Chapter-04, Energy analysis of closed circuit
//Exercise: 4.3, Page No: 170
//Title:Moving boundary work
//===================================================
model Ex4_3
//Variable section
Real W_b(unit = "kJ") "Workdone for the isothermal process";
//=====================================================
//Parameter section
parameter Real P(unit = "kPa") = 100 "Initial pressure";
parameter Real V_1(unit = "m3") = 0.4 "Intial volume";
parameter Real V_2(unit = "m3") = 0.1 "Final volume";
//=====================================================
//Library section
extends Modelica.Math;
//=====================================================
//Equation section
equation
W_b = (P*V_1*(log(V_2/V_1)));
//======================================================
end Ex4_3;