package Ex4_8
  //======================================================
  //Thermodynamics - An Engineering approach
  //Chapter-04, Energy analysis of closed circuit
  //Exercise: 4.8, Page No: 184
  //Title : Specific heat realtions of ideal gases
  //====================================================
  class Ex4_8_1
  //Variable section
  Real W_sh(unit = "Btu") "Amount of paddle wheel work done on the system";
  Real T_2(unit = "deg.F") "Final temperature";
  //=====================================================
  //Parameter section
  parameter Real Wsh(unit = "hp") = 0.02 "powerrating in paddle wheel";
  parameter Real del_t(unit = "hr") = 0.5 "Time taken in hours";
  parameter Real m(unit = "lbm") = 1.5 "Mass in lbm";
  parameter Real T_1(unit = "deg.F") = 80 "Intial temperature";
  parameter Real Cv_avg(unit = "Btu/lbm.degF") = 0.753;
  //=====================================================
  //Equation section
  equation
  W_sh = Wsh*del_t*2545;
  //2545 is multiplied to convert hp to Btu
  T_2 = (W_sh/(m*Cv_avg))+T_1;
  //=====================================================
  end Ex4_8_1;

  class Ex4_8_2
  //Variable section
  Real W_sh(unit = "Btu") "Amount of paddle wheel work done on the system";
  Real T_2(unit = "deg.F") "Final temperature";
  Real P_2(unit = "psia") "Final pressure in psi";
  //=====================================================
  //Parameter section
  parameter Real Wsh(unit = "hp") = 0.02 "powerrating in paddle wheel";
  parameter Real del_t(unit = "hr") = 0.5 "Time taken in hours";
  parameter Real m(unit = "lbm") = 1.5 "Mass in lbm";
  parameter Real T_1(unit = "deg.F") = 80 "Intial temperature";
  parameter Real Cv_avg(unit = "Btu/lbm.degF") = 0.753;
  parameter Real P_1(unit = "psi") = 50 "Initial pressure in psi";
  //=====================================================
  //Equation section
  equation
  W_sh = Wsh*del_t*2545;
  //2545 is multiplied to convert hp to Btu
  T_2 = (W_sh/(m*Cv_avg))+T_1;
  P_2 = P_1*((T_2+460)/(T_1+460));
  //=====================================================
  end Ex4_8_2;
end Ex4_8;
