//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.1, Page No: 219
//Title : Conversation of mass
package Ex5_1
//=======================================================
  class Ex5_1_a
  //Variable section
  Real v(unit = "l/s") "Volumetric flowrate in l/s";
  Real m(unit = "Kg/s") "mass flowrate in Kg/s";
  //=====================================================
  //Parameter section
  parameter Real rho(unit = "Kg/l") = 1 "Density of water in Kg/l";
  parameter Real del_t(unit = "s") = 50 "Time taken in seconds";
  parameter Real V(unit = "gallon") = 10 "Volume in gallon";
  //=====================================================
  //Equation section
  equation
  v = ((V/del_t)*3.7854);
  //3.7854 is multiplied to convert from gallon to litre
  m = rho*v;
  //=====================================================
  end Ex5_1_a;

class Ex5_1_b
//Variable section
Real Ae(unit = "m2") "Area  in l/s";
Real Ve(unit = "m/s") "Average velocity of water at nozzle exit in m/s";
//=====================================================
//Parameter section
parameter Real re(unit = "cm") = 0.4 "Radius of nozzle in cm";
parameter Real v(unit = "l/s") = 0.757 "Volumetric flowrate in l/s";
//=====================================================
//Library section 
extends Modelica.Constants;
//=====================================================
//Equation section
equation
Ae = (pi*((re*0.01)^2));
//0.01 is multiplied to convert cm to m
Ve = v/(Ae*1000);
//1000 is divided to convert l to m3
//=====================================================
end Ex5_1_b;
end Ex5_1;
