//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.11, Page No: 245
//Title : Pipe and duct flow
//===================================================
class Ex5_11
 //=================================================
  //Variable section
  Real T_2(unit = "deg.C") "Temperature at exit";
  Real m(unit = "Kg/sec") "Mass flow of air through duct";
  Real v1(unit = "m3/Kg") "Specific volume";
  //=================================================
  //Parameter section
  parameter Real R(unit = "kPa.m3/Kg.K") = 0.287 "Universal gas constant";
  parameter Real P_1(unit = "kPa") = 100 "Pressure of air which enters the duct";
  parameter Real T_1(unit = "deg.C") = 17 "Temperature of air";
  parameter Real V_1(unit = "m3/min") = 150 "Volumetric flowrate of air";
  parameter Real W_e(unit = "kW") = 15 "Electric heating power input";
  parameter Real Q_out(unit = "W") = 200 "Rate of heat loss from air in duct to the surroundings";
  parameter Real Cp(unit = "kJ/Kg.deg.C") = 1.005 "Specicifc heat of air";
  //================================================
  //Equation section
  equation
v1 = (R*(T_1+273))/P_1;
m = V_1/(v1*60);
T_2 = W_e/(m*Cp)+(T_1); 
end Ex5_11;