//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.13, Page No: 250
//Title : Energy analysis of unsteady state systems
//===================================================
package Ex5_13
  class Ex5_13_a
  //=================================================
  //Variable section
  Real P_abs(unit = "kPa") "Absolute pressure in kPa";
  Real T(unit = "deg.C") "Temperature in deg.C at saturation pressure i.e., 175kPa from table A-5";
  //=================================================
  //Parameter section
  parameter Real P_gauge(unit = "kPa") = 75 "Operating pressure";
  parameter Real P_atm(unit = "kPa") = 100 "Atmospheric Pressure";
  //================================================
  //Equation section
  equation
  P_abs = P_gauge + P_atm;
  T = 116.04;
  end Ex5_13_a;

  class Ex5_13_b
  //=================================================
    //Variable section
    Real Q_in(unit = "kJ") "Amount of heat transfer during this process";
    Real v1(unit = "m3/Kg") "Specific volume";
    Real x1;
    Real x2;
    Real vfg;
    Real vf;
    Real vf_1;
    Real u1(unit = "kJ/Kg") "Internal energy";
    Real u2(unit = "kJ/Kg") "Internal energy";
    Real v2(unit = "kJ/Kg") "Internal energy";
    Real m2(unit = "Kg") "Mass of amount of water left";
    //=================================================
    //Parameter section
    parameter Real Qin(unit = "kJ/s") = 0.5 "Heat supplied to pressure cooker at rate in 30 minutes";
    parameter Real t(unit = "min") = 30 "Pressure of air which enters the duct";
    parameter Real he(unit = "kJ/Kg") = 2700.2 "Enthalpy at 175 kPa";
    parameter Real V(unit = "m3") = 0.006 "Volume of cooker";
    parameter Real m1(unit = "Kg") = 1 "Mass of cooker";
    parameter Real ufg(unit = "kJ/Kg") = 2037.7;
    parameter Real uf(unit = "kJ/Kg") = 486.82 ;
    parameter Real x(unit = "%") = 70;
    parameter Real y = 1.004;
    //================================================
    //Equation section
    equation
  Q_in = Qin*t*60;
  v1 = V/m1;
  vf = v1 - vf_1;
  vfg = y - vf;
  x1 = (v1 - vf)/vfg; 
  u1 = uf + ufg*x1;
  u2 = uf + x2*ufg;
  v2 = vf + x2*vfg;
  Q_in = ((m1 - (V/v2))*he) + (((V/v2)*u2) - m1*u1);
  vf_1 = (V*x)/100;
  m2 = V/v2;
  end Ex5_13_b;
end Ex5_13;
