//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.4, Page No: 234
//Title : Energy analysis of steady - flow systems
//==========================================================
package Ex5_4
  class Ex5_4_a
  //Variable section 
  Real V_1(unit = "m3/Kg") "Specific volume in m3/Kg";
  Real m(unit = "Kg/s") "Mass flowrate of air in Kg/sec";
  //=========================================================
  //parameter section
  parameter Real R(unit = "kPa.m3/Kg.K") = 0.287 "Universal gas constant";
  parameter Real T_1(unit = "deg.C") = 10 "Temperature of air";
  parameter Real P(unit = "kPa") = 80 "Inlet pressure of air";
  parameter Real A1(unit = "m2") = 0.4   "Area of inlet diffuser";
  parameter Real v_1(unit = "m/s") = 200 "Velocity of jet engine";
  //=========================================================
  //Equation section
  equation
  V_1 = R*(T_1+273.15)/P;
  m = v_1*A1*(1/V_1);
  //=========================================================
  end Ex5_4_a;

  class Ex5_4_b
  //Variable section 
  Real h_2(unit = "kJ/Kg") "Enthalpy at the exit of diffuser";
  Real T_2(unit = "K") "Temperature at the end of diffuser";
  //=========================================================
  //parameter section
  parameter Real V_2(unit = "m/s") = 0 "Velocity in m/s";
  parameter Real h_1(unit = "kJ/Kg") = 283.14 "Enthalpy of diffuser inlet is taken from table A-17";
  parameter Real V_1(unit = "m/s") = 200 "Velocity of jet engine";
  //=========================================================
  //Equation section
  equation
  h_2 = h_1 - ((V_2^2) - (V_1^2))/2*(1/1000);
  T_2 = 303;
  //T_2 is taken from table A-17 for h_2 value
  //=========================================================
  end Ex5_4_b;
end Ex5_4;
