//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.5, Page No: 235
//Title : Energy analysis of steady - flow systems
//==========================================================
package Ex5_5
  class Ex5_5_a
  //Variable section 
  Real V_1(unit = "ft/s") "Velocity of air at inlet in m/s";
  //=========================================================
  //parameter section
  parameter Real m(unit = "lbm/s") = 10  "Mass flowrate through the nozzle in lbm/sec";
  parameter Real T_1(unit = "deg.F") = 700 "Temperature of steam in deg.F";
  parameter Real P_1(unit = "Psia") = 250 "Steam pressure";
  parameter Real A1(unit = "ft2") = 0.2   "Area of inlet diffuser";
  parameter Real v_1(unit = "ft3/lbm") = 2.6883 "Velocity of jet engine";
  //=========================================================
  //Equation section
  equation
  V_1 = m*v_1/A1;
  //=========================================================
  end Ex5_5_a;

  class Ex5_5_b
  //Variable section 
  Real h_2(unit = "kJ/Kg") "Enthalpy at the exit of diffuser";
  Real T_2(unit = "deg.F") "Temperature at the end of nozzle";
  //=========================================================
  //parameter section
  parameter Real V_1(unit = "ft/s") = 134.4 "Inlet velocity in ft/s";
  parameter Real V_2(unit = "ft/s") = 900 "Velocity of steam which leaves nozzle";
  parameter Real h_1(unit = "Btu/lbm") = 1371.4 "Enthalpy of air at 200 psia is taken from table A-17";
  parameter Real q_out(unit = "Btu/lbm") = 1.2 "Heat loses from the nozzle per unit  mass of the steam";
  //=========================================================
  //Equation section
  equation
  h_2 = h_1 - q_out - (((V_2^2) - (V_1^2))/2)*(1/25037);
  T_2 = 662;
  //From table A-6E for pressure 200 psia and at h_2
  //=========================================================
  end Ex5_5_b;
end Ex5_5;
