//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.7, Page No: 237
//Title : Energy analysis of steady - flow systems
//==========================================================
package Ex5_7
  class Ex5_7_a
  //Variable section 
  Real h_2(unit = "kJ/Kg") "Enthalpy of saturated liquid vapour mixture at 15 kPa";
  Real del_h(unit = "kJ/Kg") "Difference in enthalpy";
  Real del_ke(unit = "kJ/Kg") "Difference in kinetic energy";
    Real del_Pe(unit = "kJ/Kg") "Difference in potential energy";
    //=========================================================
    //parameter section
    parameter Real h_1(unit = "kJ/Kg") = 3248.4  "Enthalpy at inlet of turbine for P1 = 2 MPa and T1 = 400 deg.C";
    parameter Real h_f(unit = "kJ/Kg") = 225.94 "Enthalpy";
    parameter Real hfg(unit = "kJ/Kg") = 2372.3 "Enthalpy";
    parameter Real x2(unit = "%") = 90;
    parameter Real V_1(unit = "m/s") = 50 "Velocity at inlet";
    parameter Real V_2(unit = "m/s") = 180 "Velocity at outlet";
    parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
    parameter Real Z2(unit = "m") = 6 "Height in m";
    parameter Real Z1(unit = "m") = 10 "Height in m";
    //=========================================================
    //Equation section
    equation
    h_2 = h_f + (x2/100)*hfg;
    del_h = h_2 - h_1;
    del_ke = (((V_2^2)-(V_1^2))/2)*(1/1000);
    del_Pe = g*(Z2 - Z1)*(1/1000);
    //=========================================================
  end Ex5_7_a;

  class Ex5_7_b
  //Variable section
  Real W_out(unit = "kJ/Kg") "Work done by turbine by unit mass of steam";
  //========================================================
  //Parameter section
  //========================================================
  parameter Real del_h(unit = "kJ/Kg") = -887.39 "Difference in enthalpy";
  parameter Real del_ke(unit = "kJ/Kg") = 14.95 "Difference in kinetic energy";
  parameter Real del_Pe(unit = "kJ/Kg") = -0.04 "Difference in potential energy";
  //========================================================
  //Equation section
  equation
  W_out = -(del_h + del_ke + del_Pe);
  end Ex5_7_b;

  class Ex5_7_c
  //Variable section
  Real m(unit = "Kg/s") "Mass flow rate for 5 MW power output";
  //========================================================
  //Parameter section
  //========================================================
  parameter Real w_out(unit = "kJ/Kg") = 872.48 "Work done by turbine by unit mass of steam";
  parameter Real W_out(unit = "kJ/s") = 5000 "Power output";
  //========================================================
  //Equation section
  equation
  m = W_out/w_out;
  end Ex5_7_c;
end Ex5_7;
