//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.8, Page No: 239
//Title : Throttling valves
//==========================================================
model Ex5_8
//Variable section 
Real hfg(unit = "kJ/Kg") "Enthalpy";
  Real del_T(unit = "deg.C") "Power input to compressor";
  Real x2;
  //=========================================================
  //parameter section
  parameter Real hf(unit = "kJ/Kg") = 22.49  "Enthalpy at saturated temperature -22.32 deg.C and pressure 0.12MPa";
  parameter Real hg(unit = "kJ/Kg") = 236.97 "Enthalpy at saturated temperature -22.32 deg.C and pressure 0.12 MPa";
  parameter Real h_2(unit = "kJ/Kg") = 95.47 "Enthalpy at pressure 0.8kPa";
  parameter Real T_1(unit = "deg.C") = 31.31 "Saturation temperature at pressure 0.8 MPa"; 
  parameter Real T_2(unit ="deg.C") = -22.32 "Saturation temperature at pressure 0.12 MPa";
    //=========================================================
  //Equation section
  equation
  hfg = hg - hf;
  x2 = (h_2 - hf)/hfg;
del_T = T_2 - T_1;
  //=========================================================
end Ex5_8;