//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.9, Page No: 241
//Title : Mixing chambers
//==========================================================
class Ex5_9
//Variable section 
Real y "Ratio of mass flowrates of hot and cold water (m1/m2)";
  //=========================================================
  //parameter section
 parameter Real h_1(unit = "Btu/lbm") = 107.99  "Enthalpy at temperature 140 deg.F";
 parameter Real h_2(unit = "Btu/lbm") = 18.07  "Enthalpy at temperature 50 deg.F";
 parameter Real h_3(unit = "Btu/lbm") = 78.02  "Enthalpy at temperature 110 deg.F";
//=========================================================
  //Equation section
  equation
  y = (h_3 - h_2)/(h_1 - h_3);
  //=========================================================
end Ex5_9;