//======================================================
//Thermodynamics - An Engineering approach
//Chapter-06, The second law of thermodynamics
//Exercise: 6.2, Page No: 286
//Title : Heat Engines
//=======================================================
class Ex6_2
//=======================================================
//Variable section 
Real Q_H(unit = "Btu/hr") "Amount of energy input required to produce power";
Real m(unit = "lbm/hr") "Rate of fuel burnt by the engine";
//=======================================================
//Parameter section
parameter Real W_net_out(unit = "hp") = 65 " Net power of this heat engine";
parameter Real eta_th(unit = "%") = 24 "Percent chemical energy released";
parameter Real E(unit = "Btu/lbm") = 19000 "Thermal energy released for each lbm of fuel burned";
//=======================================================
//Equation section
equation
Q_H = (W_net_out*100*2545)/eta_th;
//2545 is multiplied to convert hp to Btu
m = Q_H/E;
//=======================================================
end Ex6_2;
//=======================================================