// Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.11, Page No: 361
//Title: Isentropic process of ideal gases
//================================================================
model Ex7_11
//================================================================
//Variable Section
Real P2(unit = "psia") " Final pressure of helium gas ";
//================================================================
// Parameter Section
parameter Real T1(unit ="deg.F") = 50 " initial Temperature of helium gas ";
parameter Real T2(unit ="deg.F") = 320 " Final Temperature of helium gas ";
parameter Real P1(unit = "psia ") = 14 " intial presure of helium gas";
parameter Real K(unit ="") = 1.677 " specific heat ratio of helium ";
//=================================================================
// Equation Section
equation
P2 = P1*((T2+459.67)/(T1+459.67))^(K/(K-1));
//459.67 is added to convert deg.F to R
end Ex7_11;