//===================================================
//Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.13, Page No: 369
//Title: Minimizing the compressor work
//===================================================
package Ex7_13
  class Ex7_13_a
  //=================================================
  //Variable section
  Real W_comp_in(unit = "kJ/Kg") "Compressor work per unit mass for isentropic compression";
  //=================================================
  //Parameter section
  parameter Real P1(unit = "kPa") = 100 "Inlet pressure";
  parameter Real P2(unit = "kPa") = 900 "Outlet pressure";
  parameter Real T1(unit = "K") = 300 "Inlet temperature";
  parameter Real R(unit = "kJ/Kg.K") = 0.287 "Universal gas constant";
  parameter Real k = 1.4;
  //==================================================
  //Equation section
  equation
  W_comp_in = ((k*R*T1)/(k-1))*(((P2/P1)^((k-1)/k))-1);
  end Ex7_13_a;

  class Ex7_13_b
  //=================================================
  //Variable section
  Real W_comp_in(unit = "kJ/Kg") "Compressor work per unit mass for polytropic compression";
  //=================================================
  //Parameter section
  parameter Real P1(unit = "kPa") = 100 "Inlet pressure";
  parameter Real P2(unit = "kPa") = 900 "Outlet pressure";
  parameter Real T1(unit = "K") = 300 "Inlet temperature";
  parameter Real R(unit = "kJ/Kg.K") = 0.287 "Universal gas constant";
  parameter Real n = 1.3;
  //==================================================
  //Equation section
  equation
  W_comp_in = ((n*R*T1)/(n-1))*(((P2/P1)^((n-1)/n))-1);
  end Ex7_13_b;

  class Ex7_13_c
  //=================================================
  //Variable section
  Real W_comp_in(unit = "kJ/Kg") "Compressor work per unit mass for isothermal compression";
  //=================================================
  //Parameter section
  parameter Real P1(unit = "kPa") = 100 "Inlet pressure";
  parameter Real P2(unit = "kPa") = 900 "Outlet pressure";
  parameter Real T(unit = "K") = 300 "Inlet temperature";
  parameter Real R(unit = "kJ/Kg.K") = 0.287 "Universal gas constant";
  //==================================================
  //Library section
  extends Modelica.Math;
  //==================================================
  //Equation section
  equation
  W_comp_in = R*T*(log(P2/P1));
  end Ex7_13_c;

  class Ex7_13_d
  //=================================================
  //Variable section
  Real Px(unit = "kPa") "Pressure ration across each stage";
  Real W_comp_in(unit = "kJ/Kg") "Compressor work per unit mass for two stage compressor";
  //=================================================
  //Parameter section
  parameter Real P1(unit = "kPa") = 100 "Inlet pressure";
  parameter Real P2(unit = "kPa") = 900 "Outlet pressure";
  parameter Real T1(unit = "K") = 300 "Inlet temperature";
  parameter Real R(unit = "kJ/Kg.K") = 0.287 "Universal gas constant";
  parameter Real n = 1.3;
  //==================================================
  //Equation section
  equation
  Px = (P1*P2)^(1/2);
  W_comp_in = 2*(((n*R*T1)/(n-1))*(((Px/P1)^((n-1)/n))-1));
  end Ex7_13_d;
end Ex7_13;
