//===================================================
//Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.16, Page No: 376
//Title: Isentropic efficiencies of nozzles
//===================================================
class Ex7_16
//===================================================
//Variable Section
Real V2a(unit = "m/s") " the maximum possible exit velocity";
Real V2s(unit = "m/s") " the actual exit velocity of the air ";
Real T2a(unit = "K") "the exit temperature ";
Real T2s(unit = "K") "the exit temperature at ideal state ";
//===================================================
// Parameter Section
parameter Real P1(unit = "kPa ") = 200 " inlet pressure of air";
parameter Real P2_s(unit = "kPa ") = 80 " oulet pressure of air";
parameter Real T1(unit = "K") = 950 " inlet temperature ";
parameter Real Cp_avg(unit = "kJ/Kg.K") = 1.099 " specific heat";
parameter Real k = 1.354 " constant";
parameter Real eta_T = 0.92 " isnetropic Efficiency ";
//====================================================
//Library section
extends Modelica.Math;
//====================================================
// Equation Section
equation
T2s = T1*((P2_s/P1)^((k-1)/k));
V2s = sqrt(2*Cp_avg*(T1-T2s)*1000);
T2a = T1-(eta_T*(T1-T2s));
V2a = sqrt(eta_T*V2s^2);
end Ex7_16;