//===================================================
//Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.19, Page No: 386
//Title: Entropy Balance
//===================================================
model Ex7_19
//====================================================
//Variable Section
Real S_iron(unit = "kJ/K") " the entropy change of the iron block";
Real S_lake(unit = "kJ/K") " the entropy change of the lake water";
Real S_gen(unit = "kJ/K") " the entropy generated during this process";
Real Q(unit = "kJ") " the amount of heat transfer from the iron block to the lake";
//====================================================
// Parameter Section
parameter Real Cp_avg(unit = "kJ/kg.K") = 0.45 " specific heat of iron";
parameter Real T1(unit = "K") = 500 " iron casting temperature ";
parameter Real T2(unit = "K") = 285 " lake temperature ";
parameter Real m(unit = "Kg") = 50 " Mass of iron ";
//====================================================
//Library section
extends Modelica.Math;
//====================================================
// Equation Section
equation
S_iron = m*Cp_avg*log(T2/T1);
Q = m*Cp_avg*(T1-T2);
S_lake = Q/T2;
S_gen = S_iron+S_lake;
end Ex7_19;