package Ex7_2
//======================================================
//Thermodynamics - An Engineering approach
//Chapter-07, Entropy
//Exercise: 7.2, Page No: 338
//Title : Increase of entropy principle
//=======================================================
 model Ex7_2_a
//=======================================================
//Variable section 
Real del_S_source(unit = "kJ/K") "Entropy change in source";
 Real del_S_sink(unit = "kJ/K") "Heat transfer process to a sink at 500K";
 Real S_gen(unit = "kJ/K") "Entropy generation";
//=======================================================
//Parameter section
parameter Real Q_source(unit = "kJ") = -2000 "Heat loss to source";
parameter Real T_source(unit = "K") = 800 "Source temperature";
 parameter Real T_sink(unit = "K") = 500 "Sink temperature";
 parameter Real Q_sink(unit = "kJ") = 2000 "Heat loss to sink";
//=======================================================
//Equation section
equation
del_S_source = Q_source/T_source;
 del_S_sink = Q_sink/T_sink;
 S_gen = del_S_source + del_S_sink;
//=======================================================
  end Ex7_2_a;

  model Ex7_2_b
  //=======================================================
  //Variable section 
  Real del_S_source(unit = "kJ/K") "Entropy change in source";
  Real del_S_sink(unit = "kJ/K") "Heat transfer process to a sink at 500K";
  Real S_gen(unit = "kJ/K") "Entropy generation";
  //=======================================================
  //Parameter section
  parameter Real Q_source(unit = "kJ") = -2000 "Heat loss to source";
  parameter Real T_source(unit = "K") = 800 "Source temperature";
  parameter Real T_sink(unit = "K") = 750 "Sink temperature";
  parameter Real Q_sink(unit = "kJ") = 2000 "Heat loss to sink";
  //=======================================================
  //Equation section
  equation
  del_S_source = Q_source/T_source;
  del_S_sink = Q_sink/T_sink;
  S_gen = del_S_source + del_S_sink;
  //=======================================================
  end Ex7_2_b;
end Ex7_2;
