//========================================================
////Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.20, Page No: 386
//Title: Entropy Generation in a Mixing Chamber
//========================================================
class Ex7_20
//========================================================
//Variable Section
Real S_gen(unit = "Btu/min.R") " the rate of entropy generation during this process ";
Real m2(unit = "lbm/min") " Mass flow at outlet in mxing chamber";
Real m3(unit = "lbm/min") " Mass flow in exit";
//========================================================
// Parameter Section
parameter Real m1(unit = "lbm/min") = 300 " Mass flow at inlet of mxing chamber";
parameter Real T1(unit = "R") = 530 " boundary temperature ";
parameter Real s1(unit = "Btu/lbm.R") = 0.03609 " The entropy at the inlet";
parameter Real s2(unit = "Btu/lbm.R") = 1.7406 " The entropy  at the chamber";
parameter Real s3(unit = "Btu/lbm.R") =0.18174 " The entropy  at the Exit";
parameter Real h1(unit = "Btu/lbm") = 18.07 " The enthalpy at the inlet";
parameter Real h2(unit = "Btu/lbm") = 1162.3 " The enthalpy  at the chamber";
parameter Real h3(unit = "Btu/lbm") = 97.99 " The enthalpy  at the Exit";
parameter Real Q_out(unit = "Btu/min") =  180 "The rate leaving chamber";
//=========================================================
// Equation Section
equation
m2 = (Q_out + m1*(h3-h1))/(h2-h3);
S_gen = ((m3*s3)-(m1*s1)-(m2*s2))+(Q_out/T1);
m3 = m1+m2;
end Ex7_20;