//======================================================
//Thermodynamics - An Engineering approach
//Chapter-07, Entropy
//Exercise: 7.3, Page No: 341
//Title : Entropy change of pure substances
//=======================================================
 model Ex7_3
//=======================================================
//Variable section 
Real x2;
Real S2(unit = "kJ/Kg.K");
Real del_S(unit = "kJ/K") "Entropy change of refrigerant during process";
//=======================================================
//Parameter section
parameter Real S1(unit = "kJ/Kg.K") = 1.0624 "Entropy at pressure P1 = 140kPa and temperature T1 = 20 deg.C";
parameter Real v1(unit = "m3/Kg") = 0.16544 "Specific volume at pressure P1 = 140kPa and temperature T1 = 20 deg.C";
parameter Real vf(unit = "m3/Kg") = 0.0007259 "Specific volume at pressure P2 = 100kPa";
parameter Real vg(unit = "m3/Kg") = 0.19254 "Specific volume at pressure P2 = 100kPa";
parameter Real Sf(unit = "kJ/Kg.K") = 0.07188 "Entropy";
parameter Real Sfg(unit = "kJ/Kg.K") = 0.87995 "Entropy";
parameter Real m(unit = "Kg") = 5 "Mass of refigerant";
//=======================================================
//Equation section
equation
//v1 = v2
x2 = (v1 - vf)/(vg - vf);
S2 = Sf + x2*Sfg;
del_S = m*(S2 - S1);
//=======================================================
end Ex7_3;