//======================================================
//Thermodynamics - An Engineering approach
//Chapter-07, Entropy
//Exercise: 7.4, Page No: 342
//Title : Increase of entropy principle
//=======================================================
model Ex7_4
//=======================================================
//Variable section 
Real h_2(unit = "Btu/lbm")"Enthalpy for constant pressure quasi equilibrium process at pressure 20 psia from table A-6E";
Real del_S(unit = "Btu/R") "Entropy change of water during this process";
//=======================================================
//Parameter section
parameter Real m(unit = "lbm") = 3 "Weight of water";
parameter Real h_1(unit = "Btu/lbm") = 38.08 "Enthalpy of compressed liquid at pressure 20psia and temperature 70 deg.F from table A-6E";
parameter Real S_1(unit = "Btu/lbm.R") = 0.07459 "Entropy of compressed liquid at pressure 20psia and temperature 70 deg.F from table A-6E";
parameter Real Q_in(unit = "Btu") = 3450 "Heat added to system";
parameter Real S_2(unit = "Btu/lbm.R") = 1.7761 "Entropy for constant pressure quasi equilibrium process at pressure 20 psia from table A-6E";
//=======================================================
//Equation section
equation
Q_in = m*(h_2 - h_1);
del_S = m*(S_2 - S_1); 
//=======================================================
end Ex7_4;