// Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.7, Page No: 352
//Title: Entropy change of liquids and solids
//================================================================
package Ex7_7
  model Ex7_7_a
  //================================================================
  //Variable Section
  Real del_S(unit = "kJ/Kg.K") "Entropy change of methane at inlet and outlet";
  //================================================================
  //Parameter Section
  parameter Real S1(unit = "kJ/Kg.K") = 4.875 "Entropy of methane at temperature 110K and pressure 1 MPa";
  parameter Real Cp1(unit = "kJ/Kg.K") = 3.471 "Specific heat of inlet methane at temperature 110K and pressure 1 MPa";
  parameter Real S2(unit = "kJ/Kg.K") = 5.145 "Entropy of methane at temperature 120K and pressure 5 MPa";
  parameter Real Cp2(unit = "kJ/Kg.K") = 3.486 "Specific heat of inlet methane at temperature 120K and pressure 5 MPa";
  //================================================================
  //Equation Section
  equation
  del_S = S2 - S1;
  end Ex7_7_a;

  model Ex7_7_b
  //================================================================
  //Variable Section
  Real del_S(unit = "kJ/Kg.K") "Entropy change of methane at inlet and outlet";
  Real C_avg(unit = "kJ/Kg.K") "Average specific heat";
  //================================================================
  //Parameter Section
  parameter Real T1(unit = "K") = 110 "Temperature of methane at inlet";
  parameter Real T2(unit = "K") = 120 "Temperature of methane at outlet";
  parameter Real S1(unit = "kJ/Kg.K") = 4.875 "Entropy of methane at temperature 110K and pressure 1 MPa";
  parameter Real Cp1(unit = "kJ/Kg.K") = 3.471 "Specific heat of inlet methane at temperature 110K and pressure 1 MPa";
  parameter Real S2(unit = "kJ/Kg.K") = 5.145 "Entropy of methane at temperature 120K and pressure 5 MPa";
  parameter Real Cp2(unit = "kJ/Kg.K") = 3.486 "Specific heat of inlet methane at temperature 120K and pressure 5 MPa";
  //================================================================
  //Equation Section
  equation
  C_avg = (Cp1 + Cp2)/2;
  del_S = C_avg*log(T2/T1);
  end Ex7_7_b;
end Ex7_7;
