// Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.8, Page No: 353
//Title: Economics of replacing a valve by turbine
//================================================================
class Ex7_8
//================================================================
//Variable Section
Real m(unit = "Kg/s") "Mass flow of liquid methane";
Real W_out(unit = "kW") " Maximum amount of power";
Real Savings(unit = "$/yr") " Annual power savings";
//================================================================
//Parameter Section
parameter Real v1(unit = "m3") = 0.280 "Volumteric flowrate of methane";
parameter Real h1(unit = "kJ/Kg") = 232.3 "Enthalpy at Handled Pressure";
parameter Real h2(unit = "kJ/Kg") = 222.8 "Enthalpy at Dropped Pressure";
parameter Real rho(unit = "Kg/m3") = 422.15 "Density of Methane";
parameter Real del_t(unit = "h/yr") = 8760 "amount of hours per year";
parameter Real X(unit = "$/Kwh") = 0.075 "Unit cost of power";
//================================================================
//Equation Section
equation
m = rho*v1;
W_out = m*(h1-h2);
Savings = (W_out*del_t*X);
end Ex7_8;