// Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.9, Page No: 357
//Title: Entropy change of an ideal gas
//================================================================
package Ex7_9
  class Ex7_9_a
  //================================================================
  //Variable Section
  Real del_S(unit ="kJ/Kg.K" ) " entropy change of air during compression cylce by using properties of air table ";
  //================================================================
  // Parameter Section
  parameter Real P1(unit ="kPa" ) = 100 "pressure at initial state";
  parameter Real P2(unit ="KPa") = 600 " pressure at final state";
  parameter Real T1(unit ="deg.C") = 17 " Temperature at Initial state";
  parameter Real T2(unit = "deg.C") = 57 " Temperature at final state ";
  parameter Real R(unit = "kJ/Kg.K") = 0.287" Gas constant";
  parameter Real s1(unit = "kJ/Kg.K") = 1.66802 " Entropy at initial state";
  parameter Real s2(unit = "kJ/Kg.K") = 1.79783 " Entropy at final state";
  parameter Real Cp_avg(unit = "kJ/Kg.K") = 1.006 " average spec?ific heat";
  //=================================================================
  //Library section 
  extends Modelica.Math;
  //=================================================================
  // Equation Section
  equation
  del_S = s2-s1-(R*log(P2/P1));
  end Ex7_9_a;

  class Ex7_9_b
  //Variable section
  //==========================================================================
  Real del_S(unit ="KJ/Kg.K" ) " entropy change of air during compression cylce by using average specific heats ";
  //==========================================================================
  //Parameter section
  // Parameter Section
  parameter Real P1(unit ="kPa" ) = 100 "pressure at initial state";
  parameter Real P2(unit ="KPa") = 600 " pressure at final state";
  parameter Real T1(unit ="deg.C") = 17 " Temperature at Initial state";
  parameter Real T2(unit = "deg.C") = 57 " Temperature at final state ";
  parameter Real R(unit = "kJ/Kg.K") = 0.287" Gas constant";
  parameter Real s1(unit = "kJ/Kg.K") = 1.66802 " Entropy at initial state";
  parameter Real s2(unit = "kJ/Kg.K") = 1.79783 " Entropy at final state";
  parameter Real Cp_avg(unit = "kJ/Kg.K") = 1.006 " average spec?ific heat";
  //=================================================================
  //Library section 
  extends Modelica.Math;
  //=================================================================
  // Equation Section
  equation
  del_S = Cp_avg*log((T2+273)/(T1+273))-R*log(P2/P1);
  //273 is added to convert deg.C to K
  end Ex7_9_b;
end Ex7_9;
