//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.1, Page No: 426
//Title :  Energy: work potential of energy
//=======================================================
class Ex8_1
//=======================================================
//Variable section 
Real ke(unit = "kJ/Kg") "Kinetic energy in kJ/Kg";
Real m(unit = "Kg/s") "Mass flowrate in Kg/s";
Real P_max(unit = "kW") "Maximum power in kW";
Real Area(unit = "m2") "Area of turbine rotor in m2";
//=======================================================
//Parameter section
parameter Real V(unit = "m/sec") = 10 "velocity of air";
parameter Real rho(unit = "Kg/m3") = 1.18 "Density of air";
parameter Real d(unit = "m") = 12 "Diameter of turbine rotor";
//=======================================================
//Library section
extends Modelica.Constants;
//=======================================================
//Equation section
equation
Area = (pi*(d^2))/4;
ke = (V^2)/(2*1000);
m = rho*Area*V;
P_max = m*ke;
//=======================================================
end Ex8_1;