//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.10, Page No: 447
//Title : Second law efficiency
 //=======================================================
class Ex8_10
//=======================================================
//Variable section 
Real X_destroyed(unit = "W") "Rate of energy destruction in wall";
Real Xdestroyed(unit = "W") "Rate of total energy destruction";
//=======================================================
//Parameter section
parameter Real Q(unit = "W") = 1035 "Energy input in W";
parameter Real To(unit = "deg.C") = 0 "Temperature of surroundings";
parameter Real T(unit = "deg.C") = 5 "Temperature of out surfaces of the briick wall";
parameter Real T1(unit = "deg.C") = 20 "Temperature maintained in house";
parameter Real T2(unit = "deg.C") = 27 "Temperature of house";
//=======================================================
//Equation section
equation
X_destroyed = (Q*(1-((To+273)/(T1+273)))) - (Q*(1-((To+273)/(T+273))));
Xdestroyed = (Q*(1-((To+273)/(T2+273)))) - (Q*(1-((To+273)/(To+273))));
//273 is added to convert deg.C to Kelvin
//=======================================================
end Ex8_10;